/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util.winreg;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;
import net.ftb.util.winreg.JavaInfo;
import net.ftb.util.winreg.RuntimeStreamer;
import net.ftb.util.winreg.WinRegistry;

public class JavaFinder {
    public static boolean java8Found = false;
    private static JavaInfo preferred;

    private static List<String> searchRegistry(String key, int wow64, List<String> previous) {
        List<String> result = previous;
        try {
            List<String> entries = WinRegistry.readStringSubKeys(-2147483646, key, wow64);
            for (int i = 0; entries != null && i < entries.size(); ++i) {
                String val = WinRegistry.readString(-2147483646, key + "\\" + entries.get(i), "JavaHome", wow64);
                if (result.contains(val + "\\bin\\java.exe")) continue;
                result.add(val + "\\bin\\java.exe");
            }
        }
        catch (Throwable t) {
            Logger.logError("Error Searching windows registry for java versions", t);
        }
        return result;
    }

    public static List<JavaInfo> findJavas() {
        if (OSUtils.getCurrentOS() == OSUtils.OS.MACOSX) {
            return JavaFinder.findMacJavas();
        }
        if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS) {
            return JavaFinder.findWinJavas();
        }
        return Lists.newArrayList();
    }

    protected static List<JavaInfo> findWinJavas() {
        List<String> javaExecs = new ArrayList<String>();
        javaExecs = JavaFinder.searchRegistry("SOFTWARE\\JavaSoft\\Java Runtime Environment", 512, javaExecs);
        javaExecs = JavaFinder.searchRegistry("SOFTWARE\\JavaSoft\\Java Runtime Environment", 256, javaExecs);
        javaExecs = JavaFinder.searchRegistry("SOFTWARE\\JavaSoft\\Java Development Kit", 512, javaExecs);
        javaExecs = JavaFinder.searchRegistry("SOFTWARE\\JavaSoft\\Java Development Kit", 256, javaExecs);
        javaExecs.add(System.getenv("WINDIR") + "\\system32\\java.exe");
        javaExecs.add(System.getenv("WINDIR") + "\\SysWOW64\\java.exe");
        javaExecs.add(System.getProperty("java.home") + "\\bin\\java.exe");
        ArrayList<JavaInfo> result = Lists.newArrayList();
        for (String javaPath : javaExecs) {
            if (!new File(javaPath).exists()) continue;
            try {
                result.add(new JavaInfo(javaPath));
            }
            catch (Exception e) {
                Logger.logError("Error while creating JavaInfo", e);
            }
        }
        return result;
    }

    protected static String getMacJavaPath(String javaVersion) {
        String versionInfo = RuntimeStreamer.execute(new String[]{"/usr/libexec/java_home", "-v " + javaVersion});
        if (versionInfo.contains("version \"" + javaVersion + "\"")) {
            return null;
        }
        return versionInfo.trim();
    }

    protected static List<JavaInfo> findMacJavas() {
        ArrayList<String> javaExecs = Lists.newArrayList();
        String javaVersion = JavaFinder.getMacJavaPath("1.6");
        if (javaVersion != null) {
            javaExecs.add(javaVersion + "/bin/java");
        }
        if ((javaVersion = JavaFinder.getMacJavaPath("1.7")) != null) {
            javaExecs.add(javaVersion + "/bin/java");
        }
        if ((javaVersion = JavaFinder.getMacJavaPath("1.8")) != null) {
            javaExecs.add(javaVersion + "/bin/java");
        }
        javaExecs.add("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java");
        javaExecs.add(System.getProperty("java.home") + "/bin/java");
        ArrayList<JavaInfo> result = Lists.newArrayList();
        for (String javaPath : javaExecs) {
            File javaFile = new File(javaPath);
            if (!javaFile.exists() || !javaFile.canExecute()) continue;
            try {
                result.add(new JavaInfo(javaPath));
            }
            catch (Exception e) {
                Logger.logError("Error while creating JavaInfo", e);
            }
        }
        return result;
    }

    public static String getOSBitnessJava() {
        boolean isOS64 = OSUtils.is64BitWindows();
        List<JavaInfo> javas = JavaFinder.findJavas();
        for (JavaInfo java : javas) {
            if (java.is64bits != isOS64) continue;
            return java.path;
        }
        return null;
    }

    public static JavaInfo parseJavaVersion() {
        if (preferred == null) {
            List<JavaInfo> javas = JavaFinder.findJavas();
            ArrayList<JavaInfo> java32 = Lists.newArrayList();
            ArrayList<JavaInfo> java64 = Lists.newArrayList();
            Logger.logInfo("The FTB Launcher has found the following Java versions installed:");
            for (JavaInfo java : javas) {
                Logger.logInfo(java.toString());
                if (java.isJava8()) {
                    java8Found = true;
                }
                if (!java.supportedVersion) continue;
                if (preferred == null && java != null) {
                    preferred = java;
                }
                if (java.is64bits) {
                    java64.add(java);
                    continue;
                }
                java32.add(java);
            }
            if (java64.size() > 0) {
                for (JavaInfo aJava64 : java64) {
                    if (JavaFinder.preferred.is64bits && aJava64.compareTo(preferred) != 1) continue;
                    preferred = aJava64;
                }
            }
            if (java32.size() > 0) {
                for (JavaInfo aJava32 : java32) {
                    if (JavaFinder.preferred.is64bits || aJava32.compareTo(preferred) != 1) continue;
                    preferred = aJava32;
                }
            }
            Logger.logInfo("Preferred: " + String.valueOf(preferred));
        }
        if (preferred != null) {
            return preferred;
        }
        Logger.logError("No Java versions found!");
        return null;
    }
}

